/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty9.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.seleniumhq.jetty9.io.Connection;
import org.seleniumhq.jetty9.io.EndPoint;
import org.seleniumhq.jetty9.io.SelectorManager;
import org.seleniumhq.jetty9.util.component.ContainerLifeCycle;
import org.seleniumhq.jetty9.util.component.Dumpable;
import org.seleniumhq.jetty9.util.component.DumpableCollection;
import org.seleniumhq.jetty9.util.log.Log;
import org.seleniumhq.jetty9.util.log.Logger;
import org.seleniumhq.jetty9.util.thread.ExecutionStrategy;
import org.seleniumhq.jetty9.util.thread.Invocable;
import org.seleniumhq.jetty9.util.thread.Locker;
import org.seleniumhq.jetty9.util.thread.ReservedThreadExecutor;
import org.seleniumhq.jetty9.util.thread.Scheduler;
import org.seleniumhq.jetty9.util.thread.strategy.EatWhatYouKill;

public class ManagedSelector
extends ContainerLifeCycle
implements Dumpable {
    private static final Logger LOG = Log.getLogger(ManagedSelector.class);
    private final Locker _locker = new Locker();
    private boolean _selecting = false;
    private final Queue<Runnable> _actions = new ArrayDeque<Runnable>();
    private final SelectorManager _selectorManager;
    private final int _id;
    private final ExecutionStrategy _strategy;
    private Selector _selector;
    private int _actionCount;

    public ManagedSelector(SelectorManager selectorManager, int id) {
        this._selectorManager = selectorManager;
        this._id = id;
        SelectorProducer producer = new SelectorProducer();
        Executor executor = selectorManager.getExecutor();
        this._strategy = new EatWhatYouKill((ExecutionStrategy.Producer)producer, executor, this._selectorManager.getBean(ReservedThreadExecutor.class));
        this.addBean((Object)this._strategy, true);
        this.setStopTimeout(5000L);
    }

    public Selector getSelector() {
        return this._selector;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._selector = this._selectorManager.newSelector();
        this._selectorManager.execute(this._strategy::produce);
    }

    public int size() {
        Selector s = this._selector;
        if (s == null) {
            return 0;
        }
        return s.keys().size();
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        CloseEndPoints close_endps = new CloseEndPoints();
        this.submit(close_endps);
        close_endps.await(this.getStopTimeout());
        CloseSelector close_selector = new CloseSelector();
        this.submit(close_selector);
        close_selector.await(this.getStopTimeout());
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", this);
        }
    }

    public void submit(Runnable change) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued change {} on {}", change, this);
        }
        Selector selector = null;
        try (Locker.Lock lock = this._locker.lock();){
            this._actions.offer(change);
            if (this._selecting) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            selector.wakeup();
        }
    }

    private Runnable processConnect(SelectionKey key, final Connect connect) {
        SelectableChannel channel = key.channel();
        try {
            key.attach(connect.attachment);
            boolean connected = this._selectorManager.doFinishConnect(channel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected {} {}", connected, channel);
            }
            if (connected) {
                if (connect.timeout.cancel()) {
                    key.interestOps(0);
                    return new CreateEndPoint(channel, key){

                        @Override
                        protected void failed(Throwable failure) {
                            super.failed(failure);
                            connect.failed(failure);
                        }
                    };
                }
                throw new SocketTimeoutException("Concurrent Connect Timeout");
            }
            throw new ConnectException();
        }
        catch (Throwable x) {
            connect.failed(x);
            return null;
        }
    }

    private void closeNoExceptions(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable x) {
            LOG.ignore(x);
        }
    }

    private void createEndPoint(SelectableChannel channel, SelectionKey selectionKey) throws IOException {
        EndPoint endPoint = this._selectorManager.newEndPoint(channel, this, selectionKey);
        Connection connection = this._selectorManager.newConnection(channel, endPoint, selectionKey.attachment());
        endPoint.setConnection(connection);
        selectionKey.attach(endPoint);
        endPoint.onOpen();
        this._selectorManager.endPointOpened(endPoint);
        this._selectorManager.connectionOpened(connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", endPoint);
        }
    }

    public void destroyEndPoint(EndPoint endPoint) {
        this.submit(new DestroyEndPoint(endPoint));
    }

    private int getActionSize() {
        try (Locker.Lock lock = this._locker.lock();){
            int n = this._actions.size();
            return n;
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        Selector selector = this._selector;
        if (selector != null && selector.isOpen()) {
            ArrayList<Runnable> actions2;
            try (Locker.Lock lock = this._locker.lock();){
                actions2 = new ArrayList<Runnable>(this._actions);
            }
            ArrayList keys = new ArrayList(selector.keys().size());
            DumpKeys dumpKeys = new DumpKeys(keys);
            this.submit(dumpKeys);
            dumpKeys.await(5L, TimeUnit.SECONDS);
            ManagedSelector.dump(out, indent, Arrays.asList(new DumpableCollection("keys", keys), new DumpableCollection("actions", actions2)));
        }
    }

    public String toString() {
        Selector selector = this._selector;
        return String.format("%s id=%s keys=%d selected=%d actions=%d", super.toString(), this._id, selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1, this.getActionSize());
    }

    private class DestroyEndPoint
    implements Runnable,
    Invocable,
    Closeable {
        private final EndPoint endPoint;

        public DestroyEndPoint(EndPoint endPoint) {
            this.endPoint = endPoint;
        }

        @Override
        public void run() {
            Connection connection;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed {}", this.endPoint);
            }
            if ((connection = this.endPoint.getConnection()) != null) {
                ManagedSelector.this._selectorManager.connectionClosed(connection);
            }
            ManagedSelector.this._selectorManager.endPointClosed(this.endPoint);
        }

        @Override
        public void close() {
            this.run();
        }
    }

    private class CloseSelector
    extends Invocable.NonBlocking {
        private CountDownLatch _latch = new CountDownLatch(1);

        private CloseSelector() {
        }

        @Override
        public void run() {
            Selector selector = ManagedSelector.this._selector;
            ManagedSelector.this._selector = null;
            ManagedSelector.this.closeNoExceptions(selector);
            this._latch.countDown();
        }

        public boolean await(long timeout) {
            try {
                return this._latch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException x) {
                return false;
            }
        }
    }

    private class EndPointCloser
    implements Runnable {
        private final EndPoint _endPoint;
        private final CountDownLatch _latch;

        private EndPointCloser(EndPoint endPoint, CountDownLatch latch) {
            this._endPoint = endPoint;
            this._latch = latch;
        }

        @Override
        public void run() {
            ManagedSelector.this.closeNoExceptions(this._endPoint.getConnection());
            this._latch.countDown();
        }
    }

    private class CloseEndPoints
    extends Invocable.NonBlocking {
        private final CountDownLatch _latch = new CountDownLatch(1);
        private CountDownLatch _allClosed;

        private CloseEndPoints() {
        }

        @Override
        public void run() {
            ArrayList<EndPoint> end_points = new ArrayList<EndPoint>();
            for (SelectionKey key : ManagedSelector.this._selector.keys()) {
                Object attachment;
                if (!key.isValid() || !((attachment = key.attachment()) instanceof EndPoint)) continue;
                end_points.add((EndPoint)attachment);
            }
            int size = end_points.size();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {} endPoints on {}", size, ManagedSelector.this);
            }
            this._allClosed = new CountDownLatch(size);
            this._latch.countDown();
            for (EndPoint endp : end_points) {
                ManagedSelector.this.submit(new EndPointCloser(endp, this._allClosed));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {} endPoints on {}", size, ManagedSelector.this);
            }
        }

        public boolean await(long timeout) {
            try {
                return this._latch.await(timeout, TimeUnit.MILLISECONDS) && this._allClosed.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException x) {
                return false;
            }
        }
    }

    private class ConnectTimeout
    extends Invocable.NonBlocking {
        private final Connect connect;

        private ConnectTimeout(Connect connect) {
            this.connect = connect;
        }

        @Override
        public void run() {
            SelectableChannel channel = this.connect.channel;
            if (ManagedSelector.this._selectorManager.isConnectionPending(channel)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Channel {} timed out while connecting, closing it", channel);
                }
                this.connect.failed(new SocketTimeoutException("Connect Timeout"));
            }
        }
    }

    class Connect
    extends Invocable.NonBlocking {
        private final AtomicBoolean failed = new AtomicBoolean();
        private final SelectableChannel channel;
        private final Object attachment;
        private final Scheduler.Task timeout;

        Connect(SelectableChannel channel, Object attachment) {
            this.channel = channel;
            this.attachment = attachment;
            this.timeout = ManagedSelector.this._selectorManager.getScheduler().schedule(new ConnectTimeout(this), ManagedSelector.this._selectorManager.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            try {
                this.channel.register(ManagedSelector.this._selector, 8, this);
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }

        private void failed(Throwable failure) {
            if (this.failed.compareAndSet(false, true)) {
                this.timeout.cancel();
                ManagedSelector.this.closeNoExceptions(this.channel);
                ManagedSelector.this._selectorManager.connectionFailed(this.channel, failure, this.attachment);
            }
        }
    }

    private class CreateEndPoint
    implements Runnable,
    Invocable,
    Closeable {
        private final SelectableChannel channel;
        private final SelectionKey key;

        public CreateEndPoint(SelectableChannel channel, SelectionKey key) {
            this.channel = channel;
            this.key = key;
        }

        @Override
        public void run() {
            try {
                ManagedSelector.this.createEndPoint(this.channel, this.key);
            }
            catch (Throwable x) {
                LOG.debug(x);
                this.failed(x);
            }
        }

        @Override
        public void close() {
            LOG.debug("closed creation of {}", this.channel);
            ManagedSelector.this.closeNoExceptions(this.channel);
        }

        protected void failed(Throwable failure) {
            ManagedSelector.this.closeNoExceptions(this.channel);
            LOG.debug(failure);
        }
    }

    class Accept
    extends Invocable.NonBlocking
    implements Closeable {
        private final SelectableChannel channel;
        private final Object attachment;

        Accept(SelectableChannel channel, Object attachment) {
            this.channel = channel;
            this.attachment = attachment;
        }

        @Override
        public void close() {
            LOG.debug("closed accept of {}", this.channel);
            ManagedSelector.this.closeNoExceptions(this.channel);
        }

        @Override
        public void run() {
            try {
                SelectionKey key = this.channel.register(ManagedSelector.this._selector, 0, this.attachment);
                ManagedSelector.this.submit(new CreateEndPoint(this.channel, key));
            }
            catch (Throwable x) {
                ManagedSelector.this.closeNoExceptions(this.channel);
                LOG.debug(x);
            }
        }
    }

    class Acceptor
    extends Invocable.NonBlocking
    implements Selectable,
    Closeable {
        private final SelectableChannel _channel;
        private SelectionKey _key;

        public Acceptor(SelectableChannel channel) {
            this._channel = channel;
        }

        @Override
        public void run() {
            try {
                if (this._key == null) {
                    this._key = this._channel.register(ManagedSelector.this._selector, 16, this);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} acceptor={}", this, this._key);
                }
            }
            catch (Throwable x) {
                ManagedSelector.this.closeNoExceptions(this._channel);
                LOG.warn(x);
            }
        }

        @Override
        public Runnable onSelected() {
            SelectableChannel server = this._key.channel();
            SelectableChannel channel = null;
            try {
                while ((channel = ManagedSelector.this._selectorManager.doAccept(server)) != null) {
                    ManagedSelector.this._selectorManager.accepted(channel);
                }
            }
            catch (Throwable x) {
                ManagedSelector.this.closeNoExceptions(channel);
                LOG.warn("Accept failed for channel " + channel, x);
            }
            return null;
        }

        @Override
        public void updateKey() {
        }

        @Override
        public void close() throws IOException {
            SelectionKey key = this._key;
            this._key = null;
            if (key != null && key.isValid()) {
                key.cancel();
            }
        }
    }

    private class DumpKeys
    extends Invocable.NonBlocking {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final List<Object> _dumps;

        private DumpKeys(List<Object> dumps) {
            this._dumps = dumps;
        }

        @Override
        public void run() {
            Selector selector = ManagedSelector.this._selector;
            if (selector != null && selector.isOpen()) {
                Set<SelectionKey> keys = selector.keys();
                this._dumps.add(selector + " keys=" + keys.size());
                for (SelectionKey key : keys) {
                    try {
                        this._dumps.add(String.format("SelectionKey@%x{i=%d}->%s", key.hashCode(), key.interestOps(), key.attachment()));
                    }
                    catch (Throwable x) {
                        this._dumps.add(String.format("SelectionKey@%x[%s]->%s", key.hashCode(), x, key.attachment()));
                    }
                }
            }
            this.latch.countDown();
        }

        public boolean await(long timeout, TimeUnit unit) {
            try {
                return this.latch.await(timeout, unit);
            }
            catch (InterruptedException x) {
                return false;
            }
        }
    }

    private class SelectorProducer
    implements ExecutionStrategy.Producer {
        private Set<SelectionKey> _keys = Collections.emptySet();
        private Iterator<SelectionKey> _cursor = Collections.emptyIterator();

        private SelectorProducer() {
        }

        @Override
        public Runnable produce() {
            do {
                Runnable task;
                if ((task = this.processSelected()) != null) {
                    return task;
                }
                Runnable action = this.nextAction();
                if (action != null) {
                    return action;
                }
                this.updateKeys();
            } while (this.select());
            return null;
        }

        private Runnable nextAction() {
            Selector selector = null;
            Runnable action = null;
            try (Locker.Lock lock = ManagedSelector.this._locker.lock();){
                if (ManagedSelector.this._actionCount == 0) {
                    ManagedSelector.this._actionCount = ManagedSelector.this._actions.size();
                    if (ManagedSelector.this._actionCount > 0) {
                        action = (Runnable)ManagedSelector.this._actions.poll();
                    } else {
                        ManagedSelector.this._selecting = true;
                    }
                } else if (ManagedSelector.this._actionCount == 1) {
                    ManagedSelector.this._actionCount = 0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Forcing selection, actions={}", ManagedSelector.this._actions.size());
                    }
                    if (ManagedSelector.this._actions.size() == 0) {
                        ManagedSelector.this._selecting = true;
                    } else {
                        selector = ManagedSelector.this._selector;
                        ManagedSelector.this._selecting = false;
                    }
                } else {
                    ManagedSelector.this._actionCount--;
                    action = (Runnable)ManagedSelector.this._actions.poll();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("action={} wakeup={}", action, selector != null);
            }
            if (selector != null) {
                selector.wakeup();
            }
            return action;
        }

        private boolean select() {
            block12: {
                try {
                    int actions2;
                    Selector selector = ManagedSelector.this._selector;
                    if (selector == null || !selector.isOpen()) break block12;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} waiting on select", selector);
                    }
                    int selected = selector.select();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} woken up from select, {}/{} selected", selector, selected, selector.keys().size());
                    }
                    try (Locker.Lock lock = ManagedSelector.this._locker.lock();){
                        ManagedSelector.this._selecting = false;
                        actions2 = ManagedSelector.this._actions.size();
                    }
                    this._keys = selector.selectedKeys();
                    this._cursor = this._keys.iterator();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} processing {} keys, {} actions", selector, this._keys.size(), actions2);
                    }
                    return true;
                }
                catch (Throwable x) {
                    ManagedSelector.this.closeNoExceptions(ManagedSelector.this._selector);
                    if (ManagedSelector.this.isRunning()) {
                        LOG.warn(x);
                    }
                    LOG.debug(x);
                }
            }
            return false;
        }

        private Runnable processSelected() {
            while (this._cursor.hasNext()) {
                Object attachment;
                SelectionKey key = this._cursor.next();
                if (key.isValid()) {
                    attachment = key.attachment();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("selected {} {} ", key, attachment);
                    }
                    try {
                        Runnable task;
                        if (attachment instanceof Selectable) {
                            task = ((Selectable)attachment).onSelected();
                            if (task == null) continue;
                            return task;
                        }
                        if (key.isConnectable()) {
                            task = ManagedSelector.this.processConnect(key, (Connect)attachment);
                            if (task == null) continue;
                            return task;
                        }
                        throw new IllegalStateException("key=" + key + ", att=" + attachment + ", iOps=" + key.interestOps() + ", rOps=" + key.readyOps());
                    }
                    catch (CancelledKeyException x) {
                        LOG.debug("Ignoring cancelled key for channel {}", key.channel());
                        if (!(attachment instanceof EndPoint)) continue;
                        ManagedSelector.this.closeNoExceptions((EndPoint)attachment);
                        continue;
                    }
                    catch (Throwable x) {
                        LOG.warn("Could not process key for channel " + key.channel(), x);
                        if (!(attachment instanceof EndPoint)) continue;
                        ManagedSelector.this.closeNoExceptions((EndPoint)attachment);
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector loop ignoring invalid key for channel {}", key.channel());
                }
                if (!((attachment = key.attachment()) instanceof EndPoint)) continue;
                ManagedSelector.this.closeNoExceptions((EndPoint)attachment);
            }
            return null;
        }

        private void updateKeys() {
            for (SelectionKey key : this._keys) {
                this.updateKey(key);
            }
            this._keys.clear();
        }

        private void updateKey(SelectionKey key) {
            Object attachment = key.attachment();
            if (attachment instanceof Selectable) {
                ((Selectable)attachment).updateKey();
            }
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }

    public static interface Selectable {
        public Runnable onSelected();

        public void updateKey();
    }
}

