/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;

public class FindChildElements
extends WebElementHandler<Set<Map<String, String>>>
implements JsonParametersAware {
    private volatile By by;

    public FindChildElements(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.by = this.newBySelector().pickFromJsonParameters(allParameters);
    }

    @Override
    public Set<Map<String, String>> call() throws Exception {
        List<WebElement> elements = this.getElement().findElements(this.by);
        return elements.stream().map(element -> ImmutableMap.of("ELEMENT", this.getKnownElements().add((WebElement)element))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String toString() {
        return String.format("[find child elements: %s, %s]", this.getElementAsString(), this.by);
    }
}

