/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.GridRole;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;

public class DisplayHelpServlet
extends HttpServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    public static final String HELPER_TYPE_PARAMETER = "webdriver.server.displayhelpservlet.type";
    private static final String HELPER_SERVLET_TEMPLATE = "displayhelpservlet.html";
    private static final String HELPER_SERVLET_ASSET_PATH_PREFIX = "/assets/";
    private static final String HELPER_SERVLET_RESOURCE_PATH = "org/openqa/grid/images/";
    private static final String HELPER_SERVLET_TEMPLATE_CONFIG_JSON_VAR = "${servletConfigJson}";
    private final DisplayHelpServletConfig servletConfig = new DisplayHelpServletConfig();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.initServletConfig();
        String resource = request.getPathInfo();
        if (resource.contains(HELPER_SERVLET_ASSET_PATH_PREFIX) && !resource.replace(HELPER_SERVLET_ASSET_PATH_PREFIX, "").contains("/") && !resource.replace(HELPER_SERVLET_ASSET_PATH_PREFIX, "").equals("")) {
            InputStream in = this.getResourceInputStream(resource = resource.replace(HELPER_SERVLET_ASSET_PATH_PREFIX, ""));
            if (in == null) {
                response.sendError(404);
            } else {
                response.setStatus(200);
                ByteStreams.copy(in, response.getOutputStream());
            }
        } else {
            InputStream in = this.getResourceInputStream(HELPER_SERVLET_TEMPLATE);
            if (in == null) {
                response.sendError(404);
            } else {
                StringBuilder jsonBuilder = new StringBuilder();
                try (JsonOutput out = new Json().newOutput(jsonBuilder);){
                    out.setPrettyPrint(false).write(this.servletConfig);
                }
                String json = jsonBuilder.toString();
                String htmlTemplate = new BufferedReader(new InputStreamReader(in, "UTF-8")).lines().collect(Collectors.joining("\n"));
                String updatedTemplate = htmlTemplate.replace(HELPER_SERVLET_TEMPLATE_CONFIG_JSON_VAR, json);
                if (resource.equals("/")) {
                    response.setStatus(200);
                } else {
                    response.setStatus(404);
                }
                response.setContentType("text/html");
                response.setCharacterEncoding("UTF-8");
                response.getOutputStream().print(updatedTemplate);
            }
        }
        response.flushBuffer();
    }

    private void initServletConfig() {
        if (this.servletConfig.version == null) {
            this.servletConfig.version = new BuildInfo().getReleaseLabel();
        }
        if (this.servletConfig.type == null) {
            this.servletConfig.type = this.getHelperType();
        }
        if (this.servletConfig.consoleLink == null) {
            this.servletConfig.consoleLink = this.getInitParameter("webdriver.server.consoleservlet.path", "");
        }
    }

    private String getHelperType() {
        GridRole role = GridRole.get(this.getInitParameter(HELPER_TYPE_PARAMETER, "standalone"));
        if (role == null) {
            role = GridRole.NOT_GRID;
        }
        String type = "Standalone";
        switch (role) {
            case HUB: {
                type = "Grid Hub";
                break;
            }
            case NODE: {
                type = "Grid Node";
                break;
            }
        }
        return type;
    }

    @Override
    public String getInitParameter(String param) {
        return this.getServletContext().getInitParameter(param);
    }

    private String getInitParameter(String param, String defaultValue) {
        String value = this.getInitParameter(param);
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private InputStream getResourceInputStream(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(HELPER_SERVLET_RESOURCE_PATH + resource);
        if (in == null) {
            return null;
        }
        return in;
    }

    private final class DisplayHelpServletConfig {
        String version;
        String type;
        String consoleLink;

        private DisplayHelpServletConfig() {
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String getConsoleLink() {
            return this.consoleLink;
        }
    }
}

