/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableCaptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableSectionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.RowContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.dom.NodeList;

@JsxClass(domClass=HtmlTable.class)
public class HTMLTableElement
extends RowContainer {
    private static final List<String> VALID_RULES_ = Arrays.asList("none", "groups", "rows", "cols");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public HTMLTableElement() {
    }

    @JsxGetter
    public Object getCaption() {
        NodeList captions = this.getDomNodeOrDie().getElementsByTagName("caption");
        if (captions.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(captions.get(0));
    }

    @JsxSetter
    public void setCaption(Object o) {
        if (!(o instanceof HTMLTableCaptionElement)) {
            throw Context.reportRuntimeError("Not a caption");
        }
        this.deleteCaption();
        HTMLTableCaptionElement caption = (HTMLTableCaptionElement)o;
        this.getDomNodeOrDie().appendChild(caption.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTFoot() {
        NodeList tfoots = this.getDomNodeOrDie().getElementsByTagName("tfoot");
        if (tfoots.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(tfoots.get(0));
    }

    @JsxSetter
    public void setTFoot(Object o) {
        if (!(o instanceof HTMLTableSectionElement) || !"TFOOT".equals(((HTMLTableSectionElement)o).getTagName())) {
            throw Context.reportRuntimeError("Not a tFoot");
        }
        this.deleteTFoot();
        HTMLTableSectionElement tfoot = (HTMLTableSectionElement)o;
        this.getDomNodeOrDie().appendChild(tfoot.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTHead() {
        NodeList theads = this.getDomNodeOrDie().getElementsByTagName("thead");
        if (theads.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(theads.get(0));
    }

    @JsxSetter
    public void setTHead(Object o) {
        if (!(o instanceof HTMLTableSectionElement) || !"THEAD".equals(((HTMLTableSectionElement)o).getTagName())) {
            throw Context.reportRuntimeError("Not a tHead");
        }
        this.deleteTHead();
        HTMLTableSectionElement thead = (HTMLTableSectionElement)o;
        this.getDomNodeOrDie().appendChild(thead.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTBodies() {
        final HtmlTable table = (HtmlTable)this.getDomNodeOrDie();
        return new HTMLCollection(table, false){

            @Override
            protected List<DomNode> computeElements() {
                return new ArrayList<DomNode>(table.getBodies());
            }
        };
    }

    @JsxFunction
    public Object createCaption() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("caption"));
    }

    @JsxFunction
    public Object createTFoot() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("tfoot"));
    }

    @JsxFunction
    public Object createTBody() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("tbody"));
    }

    @JsxFunction
    public Object createTHead() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("thead"));
    }

    @JsxFunction
    public void deleteCaption() {
        this.getDomNodeOrDie().removeChild("caption", 0);
    }

    @JsxFunction
    public void deleteTFoot() {
        this.getDomNodeOrDie().removeChild("tfoot", 0);
    }

    @JsxFunction
    public void deleteTHead() {
        this.getDomNodeOrDie().removeChild("thead", 0);
    }

    @Override
    protected boolean isContainedRow(HtmlTableRow row) {
        DomNode parent = row.getParentNode();
        return parent != null && parent.getParentNode() == this.getDomNodeOrDie();
    }

    @Override
    public Object insertRow(int index) {
        List rowContainers = this.getDomNodeOrDie().getByXPath("//tbody | //thead | //tfoot");
        if (rowContainers.isEmpty() || index == 0) {
            HtmlElement tBody = this.getDomNodeOrDie().appendChildIfNoneExists("tbody");
            return ((RowContainer)this.getScriptableFor(tBody)).insertRow(0);
        }
        return super.insertRow(index);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getDomNodeOrDie().getAttributeDirect("width");
    }

    @JsxSetter
    public void setWidth(String width) {
        this.getDomNodeOrDie().setAttribute("width", width);
    }

    @JsxGetter
    public String getCellSpacing() {
        return this.getDomNodeOrDie().getAttributeDirect("cellspacing");
    }

    @JsxSetter
    public void setCellSpacing(String cellSpacing) {
        this.getDomNodeOrDie().setAttribute("cellspacing", cellSpacing);
    }

    @JsxGetter
    public String getCellPadding() {
        return this.getDomNodeOrDie().getAttributeDirect("cellpadding");
    }

    @JsxSetter
    public void setCellPadding(String cellPadding) {
        this.getDomNodeOrDie().setAttribute("cellpadding", cellPadding);
    }

    @JsxGetter
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttributeDirect("border");
        return border;
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColor() {
        return this.getDomNodeOrDie().getAttribute("borderColor");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColor(String borderColor) {
        this.setColorAttribute("borderColor", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorDark() {
        return this.getDomNodeOrDie().getAttribute("borderColorDark");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorDark(String borderColor) {
        this.setColorAttribute("borderColorDark", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorLight() {
        return this.getDomNodeOrDie().getAttribute("borderColorLight");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorLight(String borderColor) {
        this.setColorAttribute("borderColorLight", borderColor);
    }

    @Override
    public String getInnerText() {
        return this.getDomNodeOrDie().asText();
    }

    @Override
    public Object appendChild(Object childObject) {
        Object appendedChild = super.appendChild(childObject);
        this.getWindow().clearComputedStyles(this);
        return appendedChild;
    }

    @Override
    public Object removeChild(Object childObject) {
        Object removedChild = super.removeChild(childObject);
        this.getWindow().clearComputedStyles(this);
        return removedChild;
    }

    @JsxGetter
    public String getSummary() {
        return this.getDomNodeOrDie().getAttributeDirect("summary");
    }

    @JsxSetter
    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    @JsxGetter
    public String getRules() {
        String rules = this.getDomNodeOrDie().getAttributeDirect("rules");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_VALIGN_SUPPORTS_IE_VALUES) && !VALID_RULES_.contains(rules)) {
            rules = "";
        }
        return rules;
    }

    @JsxSetter
    public void setRules(String rules) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_VALIGN_SUPPORTS_IE_VALUES) && !(rules = rules.toLowerCase(Locale.ROOT)).isEmpty() && !VALID_RULES_.contains(rules)) {
            throw Context.throwAsScriptRuntimeEx(new Exception("Invalid argument"));
        }
        this.setAttribute("rules", rules);
    }
}

