/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.CSSImportRuleImpl;
import com.gargoylesoftware.css.dom.CSSMediaRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.dom.CSSStyleRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.CSSValueImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.dom.Property;
import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.CSSParseException;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.condition.AttributeCondition;
import com.gargoylesoftware.css.parser.condition.BeginHyphenAttributeCondition;
import com.gargoylesoftware.css.parser.condition.ClassCondition;
import com.gargoylesoftware.css.parser.condition.Condition;
import com.gargoylesoftware.css.parser.condition.IdCondition;
import com.gargoylesoftware.css.parser.condition.LangCondition;
import com.gargoylesoftware.css.parser.condition.OneOfAttributeCondition;
import com.gargoylesoftware.css.parser.condition.PrefixAttributeCondition;
import com.gargoylesoftware.css.parser.condition.PseudoClassCondition;
import com.gargoylesoftware.css.parser.condition.SubstringAttributeCondition;
import com.gargoylesoftware.css.parser.condition.SuffixAttributeCondition;
import com.gargoylesoftware.css.parser.javacc.CSS3Parser;
import com.gargoylesoftware.css.parser.media.MediaQuery;
import com.gargoylesoftware.css.parser.selector.ChildSelector;
import com.gargoylesoftware.css.parser.selector.DescendantSelector;
import com.gargoylesoftware.css.parser.selector.DirectAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.ElementSelector;
import com.gargoylesoftware.css.parser.selector.GeneralAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.PseudoElementSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.css.parser.selector.SelectorListImpl;
import com.gargoylesoftware.css.parser.selector.SimpleSelector;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRuleList;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.MediaList;

@JsxClass
public class CSSStyleSheet
extends StyleSheet {
    private static final Log LOG = LogFactory.getLog(CSSStyleSheet.class);
    private static final Pattern NTH_NUMERIC = Pattern.compile("\\d+");
    private static final Pattern NTH_COMPLEX = Pattern.compile("[+-]?\\d*n\\w*([+-]\\w\\d*)?");
    private static final Pattern UNESCAPE_SELECTOR = Pattern.compile("\\\\([\\[\\]\\.:])");
    private final org.w3c.dom.css.CSSStyleSheet wrapped_;
    private final HTMLElement ownerNode_;
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;
    private final Map<CSSImportRule, CSSStyleSheet> imports_ = new HashMap<CSSImportRule, CSSStyleSheet>();
    private static final transient Map<String, MediaList> media_ = new HashMap<String, MediaList>();
    private String uri_;
    private boolean enabled_ = true;
    private static final Set<String> CSS2_PSEUDO_CLASSES = new HashSet<String>(Arrays.asList("link", "visited", "hover", "active", "focus", "lang", "first-child"));
    private static final Set<String> CSS3_PSEUDO_CLASSES = new HashSet<String>(Arrays.asList("checked", "disabled", "enabled", "indeterminated", "root", "target", "not()", "nth-child()", "nth-last-child()", "nth-of-type()", "nth-last-of-type()", "last-child", "first-of-type", "last-of-type", "only-child", "only-of-type", "empty", "optional", "required"));

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public CSSStyleSheet() {
        this.wrapped_ = new CSSStyleSheetImpl();
        this.ownerNode_ = null;
    }

    public CSSStyleSheet(HTMLElement element, InputSource source, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        if (source != null) {
            source.setURI(uri);
        }
        this.wrapped_ = this.parseCSS(source);
        this.uri_ = uri;
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, org.w3c.dom.css.CSSStyleSheet wrapped, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.wrapped_ = wrapped;
        this.uri_ = uri;
        this.ownerNode_ = element;
    }

    public org.w3c.dom.css.CSSStyleSheet getWrappedSheet() {
        return this.wrapped_;
    }

    public void modifyIfNecessary(ComputedCSSStyleDeclaration style, Element element, String pseudoElement) {
        BrowserVersion browser = this.getBrowserVersion();
        DomElement e = element.getDomNodeOrDie();
        List<CSSStyleSheetImpl.SelectorEntry> matchingRules = this.selects(this.getRuleIndex(), this, browser, e, pseudoElement, false);
        for (CSSStyleSheetImpl.SelectorEntry entry : matchingRules) {
            CSSStyleDeclaration dec = entry.getRule().getStyle();
            style.applyStyleFromSelector(dec, entry.getSelector());
        }
    }

    public static CSSStyleSheet loadStylesheet(HTMLElement element, HtmlLink link, String url) {
        CSSStyleSheet sheet;
        HtmlPage page = (HtmlPage)element.getDomNodeOrDie().getPage();
        String uri = page.getUrl().toExternalForm();
        try {
            WebResponse response;
            WebRequest request;
            WebClient client = page.getWebClient();
            if (link != null) {
                String type;
                request = link.getWebRequest();
                if (element.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLLINK_CHECK_TYPE_FOR_STYLESHEET) && StringUtils.isNotBlank(type = link.getTypeAttribute()) && !"text/css".equals(type)) {
                    InputSource source = new InputSource(new StringReader(""));
                    return new CSSStyleSheet(element, source, uri);
                }
                response = link.getWebResponse(true, request);
            } else {
                String accept = client.getBrowserVersion().getCssAcceptHeader();
                request = new WebRequest(new URL(url), accept);
                request.setAdditionalHeader("Referer", uri);
                response = client.loadWebResponse(request);
            }
            Cache cache = client.getCache();
            Object fromCache = cache.getCachedObject(request);
            if (fromCache instanceof org.w3c.dom.css.CSSStyleSheet) {
                uri = request.getUrl().toExternalForm();
                sheet = new CSSStyleSheet(element, (org.w3c.dom.css.CSSStyleSheet)fromCache, uri);
            } else {
                uri = response.getWebRequest().getUrl().toExternalForm();
                client.printContentIfNecessary(response);
                client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                String contentType = response.getContentType();
                InputSource source = StringUtils.isEmpty(contentType) || "text/css".equals(contentType) ? new InputSource(response.getContentAsStream(), response.getContentCharset().name()) : new InputSource(new StringReader(""));
                sheet = new CSSStyleSheet(element, source, uri);
                if (!cache.cacheIfPossible(request, response, sheet.getWrappedSheet())) {
                    response.cleanUp();
                }
            }
        }
        catch (FailingHttpStatusCodeException e) {
            LOG.error("Exception loading " + uri, e);
            InputSource source = new InputSource(new StringReader(""));
            sheet = new CSSStyleSheet(element, source, uri);
        }
        catch (IOException e) {
            LOG.error("IOException loading " + uri, e);
            InputSource source = new InputSource(new StringReader(""));
            sheet = new CSSStyleSheet(element, source, uri);
        }
        catch (RuntimeException e) {
            LOG.error("RuntimeException loading " + uri, e);
            throw Context.reportRuntimeError("Exception: " + e);
        }
        catch (Exception e) {
            LOG.error("Exception loading " + uri, e);
            throw Context.reportRuntimeError("Exception: " + e);
        }
        return sheet;
    }

    public static boolean selects(BrowserVersion browserVersion, Selector selector, DomElement element, String pseudoElement, boolean fromQuerySelectorAll) {
        switch (selector.getSelectorType()) {
            case ELEMENT_NODE_SELECTOR: {
                ElementSelector es = (ElementSelector)selector;
                String name = es.getLocalNameLowerCase();
                if (name == null || name.equals(element.getLowercaseName())) {
                    List<Condition> conditions = es.getConditions();
                    if (conditions != null) {
                        for (Condition condition : conditions) {
                            if (CSSStyleSheet.selects(browserVersion, condition, element, fromQuerySelectorAll)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            case CHILD_SELECTOR: {
                DomNode parentNode = element.getParentNode();
                if (parentNode == element.getPage()) {
                    return false;
                }
                if (!(parentNode instanceof HtmlElement)) {
                    return false;
                }
                ChildSelector cs = (ChildSelector)selector;
                return CSSStyleSheet.selects(browserVersion, cs.getSimpleSelector(), element, pseudoElement, fromQuerySelectorAll) && CSSStyleSheet.selects(browserVersion, cs.getAncestorSelector(), (HtmlElement)parentNode, pseudoElement, fromQuerySelectorAll);
            }
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                SimpleSelector simpleSelector = ds.getSimpleSelector();
                if (CSSStyleSheet.selects(browserVersion, simpleSelector, element, pseudoElement, fromQuerySelectorAll)) {
                    DomNode ancestor = element;
                    if (simpleSelector.getSelectorType() != Selector.SelectorType.PSEUDO_ELEMENT_SELECTOR) {
                        ancestor = ancestor.getParentNode();
                    }
                    Selector dsAncestorSelector = ds.getAncestorSelector();
                    while (ancestor instanceof HtmlElement) {
                        if (CSSStyleSheet.selects(browserVersion, dsAncestorSelector, (HtmlElement)ancestor, pseudoElement, fromQuerySelectorAll)) {
                            return true;
                        }
                        ancestor = ancestor.getParentNode();
                    }
                }
                return false;
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                if (CSSStyleSheet.selects(browserVersion, das.getSimpleSelector(), element, pseudoElement, fromQuerySelectorAll)) {
                    DomNode prev;
                    for (prev = element.getPreviousSibling(); prev != null && !(prev instanceof HtmlElement); prev = prev.getPreviousSibling()) {
                    }
                    return prev != null && CSSStyleSheet.selects(browserVersion, das.getSelector(), (HtmlElement)prev, pseudoElement, fromQuerySelectorAll);
                }
                return false;
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                if (CSSStyleSheet.selects(browserVersion, gas.getSimpleSelector(), element, pseudoElement, fromQuerySelectorAll)) {
                    for (DomNode prev1 = element.getPreviousSibling(); prev1 != null; prev1 = prev1.getPreviousSibling()) {
                        if (!(prev1 instanceof HtmlElement) || !CSSStyleSheet.selects(browserVersion, gas.getSelector(), (HtmlElement)prev1, pseudoElement, fromQuerySelectorAll)) continue;
                        return true;
                    }
                }
                return false;
            }
            case PSEUDO_ELEMENT_SELECTOR: {
                if (pseudoElement != null && !pseudoElement.isEmpty() && pseudoElement.charAt(0) == ':') {
                    String pseudoName = ((PseudoElementSelector)selector).getLocalName();
                    return pseudoName.equals(pseudoElement.substring(1));
                }
                return false;
            }
        }
        LOG.error("Unknown CSS selector type '" + (Object)((Object)selector.getSelectorType()) + "'.");
        return false;
    }

    static boolean selects(BrowserVersion browserVersion, Condition condition, DomElement element, boolean fromQuerySelectorAll) {
        switch (condition.getConditionType()) {
            case ID_CONDITION: {
                IdCondition ac4 = (IdCondition)condition;
                return ac4.getValue().equals(element.getId());
            }
            case CLASS_CONDITION: {
                ClassCondition ac3 = (ClassCondition)condition;
                String v3 = ac3.getValue();
                if (v3.indexOf(92) > -1) {
                    v3 = UNESCAPE_SELECTOR.matcher(v3).replaceAll("$1");
                }
                String a3 = element.getAttributeDirect("class");
                return CSSStyleSheet.selectsWhitespaceSeparated(v3, a3);
            }
            case ATTRIBUTE_CONDITION: {
                AttributeCondition ac1 = (AttributeCondition)condition;
                String value = ac1.getValue();
                if (value != null) {
                    String attrValue;
                    if (value.indexOf(92) > -1) {
                        value = UNESCAPE_SELECTOR.matcher(value).replaceAll("$1");
                    }
                    return DomElement.ATTRIBUTE_NOT_DEFINED != (attrValue = element.getAttribute(ac1.getLocalName())) && attrValue.equals(value);
                }
                return element.hasAttribute(ac1.getLocalName());
            }
            case PREFIX_ATTRIBUTE_CONDITION: {
                PrefixAttributeCondition pac = (PrefixAttributeCondition)condition;
                String prefixValue = pac.getValue();
                return !"".equals(prefixValue) && element.getAttribute(pac.getLocalName()).startsWith(prefixValue);
            }
            case SUFFIX_ATTRIBUTE_CONDITION: {
                SuffixAttributeCondition sac = (SuffixAttributeCondition)condition;
                String suffixValue = sac.getValue();
                return !"".equals(suffixValue) && element.getAttribute(sac.getLocalName()).endsWith(suffixValue);
            }
            case SUBSTRING_ATTRIBUTE_CONDITION: {
                SubstringAttributeCondition suac = (SubstringAttributeCondition)condition;
                String substringValue = suac.getValue();
                return !"".equals(substringValue) && element.getAttribute(suac.getLocalName()).contains(substringValue);
            }
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: {
                BeginHyphenAttributeCondition bhac = (BeginHyphenAttributeCondition)condition;
                String v = bhac.getValue();
                String a = element.getAttribute(bhac.getLocalName());
                return CSSStyleSheet.selects(v, a, '-');
            }
            case ONE_OF_ATTRIBUTE_CONDITION: {
                OneOfAttributeCondition ooac = (OneOfAttributeCondition)condition;
                String v2 = ooac.getValue();
                String a2 = element.getAttribute(ooac.getLocalName());
                return CSSStyleSheet.selects(v2, a2, ' ');
            }
            case LANG_CONDITION: {
                String lcLang = ((LangCondition)condition).getLang();
                int lcLangLength = lcLang.length();
                DomNode node = element;
                while (node instanceof HtmlElement) {
                    String nodeLang = ((HtmlElement)node).getAttributeDirect("lang");
                    if (DomElement.ATTRIBUTE_NOT_DEFINED != nodeLang) {
                        return nodeLang.startsWith(lcLang) && (nodeLang.length() == lcLangLength || '-' == nodeLang.charAt(lcLangLength));
                    }
                    node = node.getParentNode();
                }
                return false;
            }
            case PSEUDO_CLASS_CONDITION: {
                return CSSStyleSheet.selectsPseudoClass(browserVersion, (PseudoClassCondition)condition, element, fromQuerySelectorAll);
            }
        }
        LOG.error("Unknown CSS condition type '" + (Object)((Object)condition.getConditionType()) + "'.");
        return false;
    }

    private static boolean selects(String condition, String attribute, char separator) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        if (attribLength > conditionLength) {
            if (separator == attribute.charAt(conditionLength) && attribute.startsWith(condition)) {
                return true;
            }
            if (separator == attribute.charAt(attribLength - conditionLength - 1) && attribute.endsWith(condition)) {
                return true;
            }
            if (attribLength + 1 > conditionLength) {
                StringBuilder tmp = new StringBuilder(conditionLength + 2);
                tmp.append(separator).append(condition).append(separator);
                return attribute.contains(tmp);
            }
            return false;
        }
        return attribute.equals(condition);
    }

    private static boolean selectsWhitespaceSeparated(String condition, String attribute) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        int pos = attribute.indexOf(condition);
        while (pos != -1) {
            if (pos > 0 && !Character.isWhitespace(attribute.charAt(pos - 1))) {
                pos = attribute.indexOf(condition, pos + 1);
                continue;
            }
            int lastPos = pos + condition.length();
            if (lastPos >= attribLength || Character.isWhitespace(attribute.charAt(lastPos))) {
                return true;
            }
            pos = attribute.indexOf(condition, pos + 1);
        }
        return false;
    }

    private static boolean selectsPseudoClass(BrowserVersion browserVersion, PseudoClassCondition condition, DomElement element, boolean fromQuerySelectorAll) {
        String value;
        Object sobj;
        if (browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (sobj = element.getPage().getScriptableObject()) instanceof HTMLDocument && ((HTMLDocument)sobj).getDocumentMode() < 8) {
            return false;
        }
        switch (value = condition.getValue()) {
            case "root": {
                return element == element.getPage().getDocumentElement();
            }
            case "enabled": {
                return element instanceof DisabledElement && !((DisabledElement)((Object)element)).isDisabled();
            }
            case "disabled": {
                return element instanceof DisabledElement && ((DisabledElement)((Object)element)).isDisabled();
            }
            case "focus": {
                HtmlPage htmlPage = element.getHtmlPageOrNull();
                if (htmlPage != null) {
                    DomElement focus = htmlPage.getFocusedElement();
                    return element == focus;
                }
                return false;
            }
            case "checked": {
                return element instanceof HtmlCheckBoxInput && ((HtmlCheckBoxInput)element).isChecked() || element instanceof HtmlRadioButtonInput && ((HtmlRadioButtonInput)element).isChecked() || element instanceof HtmlOption && ((HtmlOption)element).isSelected();
            }
            case "required": {
                return (element instanceof HtmlInput || element instanceof HtmlSelect || element instanceof HtmlTextArea) && element.hasAttribute("required");
            }
            case "optional": {
                return (element instanceof HtmlInput || element instanceof HtmlSelect || element instanceof HtmlTextArea) && !element.hasAttribute("required");
            }
            case "first-child": {
                for (DomNode n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "last-child": {
                for (DomNode n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "first-of-type": {
                String firstType = element.getNodeName();
                for (DomNode n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(firstType)) continue;
                    return false;
                }
                return true;
            }
            case "last-of-type": {
                String lastType = element.getNodeName();
                for (DomNode n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(lastType)) continue;
                    return false;
                }
                return true;
            }
            case "only-child": {
                DomNode n;
                for (n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                for (n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "only-of-type": {
                DomNode n;
                String type = element.getNodeName();
                for (n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(type)) continue;
                    return false;
                }
                for (n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(type)) continue;
                    return false;
                }
                return true;
            }
            case "empty": {
                return CSSStyleSheet.isEmpty(element);
            }
            case "target": {
                if (fromQuerySelectorAll && browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NO_TARGET)) {
                    return false;
                }
                String ref = element.getPage().getUrl().getRef();
                return StringUtils.isNotBlank(ref) && ref.equals(element.getId());
            }
            case "hover": {
                return element.isMouseOver();
            }
        }
        if (value.startsWith("nth-child(")) {
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getPreviousSibling()) {
                if (!(n instanceof DomElement)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("nth-last-child(")) {
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getNextSibling()) {
                if (!(n instanceof DomElement)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("nth-of-type(")) {
            String nthType = element.getNodeName();
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getPreviousSibling()) {
                if (!(n instanceof DomElement) || !((DomNode)n).getNodeName().equals(nthType)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("nth-last-of-type(")) {
            String nthLastType = element.getNodeName();
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getNextSibling()) {
                if (!(n instanceof DomElement) || !((DomNode)n).getNodeName().equals(nthLastType)) continue;
                ++index;
            }
            return CSSStyleSheet.getNth(nth, index);
        }
        if (value.startsWith("not(")) {
            String selectors = value.substring(value.indexOf(40) + 1, value.length() - 1);
            final AtomicBoolean errorOccured = new AtomicBoolean(false);
            CSSErrorHandler errorHandler = new CSSErrorHandler(){

                @Override
                public void warning(CSSParseException exception) throws CSSException {
                }

                @Override
                public void fatalError(CSSParseException exception) throws CSSException {
                    errorOccured.set(true);
                }

                @Override
                public void error(CSSParseException exception) throws CSSException {
                    errorOccured.set(true);
                }
            };
            CSSOMParser parser = new CSSOMParser(new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            try {
                SelectorList selectorList = parser.parseSelectors(new InputSource(new StringReader(selectors)));
                if (errorOccured.get() || selectorList == null || selectorList.size() != 1) {
                    throw new CSSException("Invalid selectors: " + selectors);
                }
                CSSStyleSheet.validateSelectors(selectorList, 9, element);
                return !CSSStyleSheet.selects(browserVersion, (Selector)selectorList.get(0), element, null, fromQuerySelectorAll);
            }
            catch (IOException e) {
                throw new CSSException("Error parsing CSS selectors from '" + selectors + "': " + e.getMessage());
            }
        }
        return false;
    }

    private static boolean isEmpty(DomElement element) {
        for (DomNode n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof DomElement) && !(n instanceof DomText)) continue;
            return false;
        }
        return true;
    }

    private static boolean getNth(String nth, int index) {
        String value;
        if ("odd".equalsIgnoreCase(nth)) {
            return index % 2 != 0;
        }
        if ("even".equalsIgnoreCase(nth)) {
            return index % 2 == 0;
        }
        int nIndex = nth.indexOf(110);
        int a = 0;
        if (nIndex != -1) {
            value = nth.substring(0, nIndex).trim();
            if ("-".equals(value)) {
                a = -1;
            } else {
                if (value.startsWith("+")) {
                    value = value.substring(1);
                }
                a = NumberUtils.toInt(value, 1);
            }
        }
        if ((value = nth.substring(nIndex + 1).trim()).startsWith("+")) {
            value = value.substring(1);
        }
        int b = NumberUtils.toInt(value, 0);
        if (a == 0) {
            return index == b && b > 0;
        }
        double n = (double)(index - b) / (double)a;
        return n >= 0.0 && n % 1.0 == 0.0;
    }

    private org.w3c.dom.css.CSSStyleSheet parseCSS(InputSource source) {
        CSSStyleSheetImpl ss;
        try {
            CSSErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser(new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            ss = parser.parseStyleSheet(source, null);
        }
        catch (Throwable t) {
            LOG.error("Error parsing CSS from '" + CSSStyleSheet.toString(source) + "': " + t.getMessage(), t);
            ss = new CSSStyleSheetImpl();
        }
        return ss;
    }

    public SelectorList parseSelectors(InputSource source) {
        SelectorList selectors;
        try {
            CSSErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser(new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            selectors = parser.parseSelectors(source);
            if (null == selectors) {
                selectors = new SelectorListImpl();
            }
        }
        catch (Throwable t) {
            LOG.error("Error parsing CSS selectors from '" + CSSStyleSheet.toString(source) + "': " + t.getMessage(), t);
            selectors = new SelectorListImpl();
        }
        return selectors;
    }

    static MediaList parseMedia(CSSErrorHandler errorHandler, String mediaString) {
        MediaList media = media_.get(mediaString);
        if (media != null) {
            return media;
        }
        try {
            CSSOMParser parser = new CSSOMParser(new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            InputSource source = new InputSource(new StringReader(mediaString));
            media = new MediaListImpl(parser.parseMedia(source));
            if (media != null) {
                media_.put(mediaString, media);
                return media;
            }
        }
        catch (Exception e) {
            LOG.error("Error parsing CSS media from '" + mediaString + "': " + e.getMessage(), e);
        }
        media = new MediaListImpl(null);
        media_.put(mediaString, media);
        return media;
    }

    private static String toString(InputSource source) {
        try {
            Reader reader = source.getReader();
            if (null != reader) {
                if (reader instanceof StringReader) {
                    StringReader sr = (StringReader)reader;
                    sr.reset();
                }
                return IOUtils.toString(reader);
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    @JsxGetter
    public HTMLElement getOwnerNode() {
        return this.ownerNode_;
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public HTMLElement getOwningElement() {
        return this.ownerNode_;
    }

    @JsxGetter(value={SupportedBrowser.IE, SupportedBrowser.CHROME})
    public CSSRuleList getRules() {
        return this.getCssRules();
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    @JsxGetter
    public String getHref() {
        HtmlElement node;
        BrowserVersion version = this.getBrowserVersion();
        if (this.ownerNode_ != null && (node = this.ownerNode_.getDomNodeOrDie()) instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)node;
            HtmlPage page = (HtmlPage)link.getPage();
            String href = link.getHrefAttribute();
            if ("".equals(href) && version.hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_EMPTY_IS_NULL)) {
                return null;
            }
            try {
                URL url = page.getFullyQualifiedUrl(href);
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                LOG.warn(e.getMessage(), e);
            }
        }
        return null;
    }

    @JsxFunction
    public int insertRule(String rule, int position) {
        try {
            this.initCssRules();
            int result = this.wrapped_.insertRule(rule, this.fixIndex(position));
            this.refreshCssRules();
            return result;
        }
        catch (DOMException e) {
            int pos = rule.indexOf(123);
            if (pos > -1) {
                String newRule = rule.substring(0, pos) + "{}";
                try {
                    int result = this.wrapped_.insertRule(newRule, this.fixIndex(position));
                    this.refreshCssRules();
                    return result;
                }
                catch (DOMException ex) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
            }
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        CSSRuleListImpl ruleList = (CSSRuleListImpl)this.getWrappedSheet().getCssRules();
        List<org.w3c.dom.css.CSSRule> rules = ruleList.getRules();
        int pos = 0;
        for (org.w3c.dom.css.CSSRule rule : rules) {
            if (rule instanceof CSSCharsetRule) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this, rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
        ((CSSStyleSheetImpl)this.getWrappedSheet()).resetRuleIndex();
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.wrapped_.deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction(value={SupportedBrowser.IE, SupportedBrowser.CHROME})
    public int addRule(String selector, String rule) {
        String completeRule = selector + " {" + rule + "}";
        try {
            this.initCssRules();
            this.wrapped_.insertRule(completeRule, this.wrapped_.getCssRules().getLength());
            this.refreshCssRules();
        }
        catch (DOMException e) {
            completeRule = selector + " {}";
            try {
                this.wrapped_.insertRule(completeRule, this.wrapped_.getCssRules().getLength());
                this.refreshCssRules();
            }
            catch (DOMException ex) {
                throw Context.throwAsScriptRuntimeEx(ex);
            }
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STYLESHEET_ADD_RULE_RETURNS_POS)) {
            return this.wrapped_.getCssRules().getLength() - 1;
        }
        return -1;
    }

    @JsxFunction(value={SupportedBrowser.IE, SupportedBrowser.CHROME})
    public void removeRule(int position) {
        try {
            this.initCssRules();
            this.wrapped_.deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public String getUri() {
        return this.uri_;
    }

    public boolean isActive() {
        String media;
        HtmlElement e = this.ownerNode_.getDomNodeOrNull();
        if (e instanceof HtmlStyle) {
            HtmlStyle style = (HtmlStyle)e;
            media = style.getMediaAttribute();
        } else if (e instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)e;
            media = link.getMediaAttribute();
        } else {
            return true;
        }
        if (StringUtils.isBlank(media)) {
            return true;
        }
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        MediaList mediaList = CSSStyleSheet.parseMedia(webClient.getCssErrorHandler(), media);
        return CSSStyleSheet.isActive((SimpleScriptable)this, mediaList);
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    static boolean isActive(SimpleScriptable scriptable, MediaList mediaList) {
        if (mediaList.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < mediaList.getLength(); ++i) {
            MediaQuery mediaQuery = ((MediaListImpl)mediaList).mediaQuery(i);
            boolean isActive = CSSStyleSheet.isActive(scriptable, mediaQuery);
            if (mediaQuery.isNot()) {
                boolean bl = isActive = !isActive;
            }
            if (!isActive) continue;
            return true;
        }
        return false;
    }

    private static boolean isActive(SimpleScriptable scriptable, MediaQuery mediaQuery) {
        String mediaType = mediaQuery.getMedia();
        if ("screen".equalsIgnoreCase(mediaType) || "all".equalsIgnoreCase(mediaType)) {
            for (Property property : mediaQuery.getProperties()) {
                switch (property.getName()) {
                    case "max-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "min-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-width": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "max-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "min-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val < (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-height": {
                        float val = CSSStyleSheet.pixelValue((CSSValueImpl)property.getValue(), scriptable);
                        if (!(val > (float)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "resolution": {
                        float val = CSSStyleSheet.resolutionValue((CSSValueImpl)property.getValue());
                        if (Math.round(val) == scriptable.getWindow().getScreen().getDeviceXDPI()) break;
                        return false;
                    }
                    case "max-resolution": {
                        float val = CSSStyleSheet.resolutionValue((CSSValueImpl)property.getValue());
                        if (!(val < (float)scriptable.getWindow().getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "min-resolution": {
                        float val = CSSStyleSheet.resolutionValue((CSSValueImpl)property.getValue());
                        if (!(val > (float)scriptable.getWindow().getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "orientation": {
                        String orient = property.getValue().getCssText();
                        WebWindow window = scriptable.getWindow().getWebWindow();
                        if ("portrait".equals(orient)) {
                            if (window.getInnerWidth() <= window.getInnerHeight()) break;
                            return false;
                        }
                        if ("landscape".equals(orient)) {
                            if (window.getInnerWidth() >= window.getInnerHeight()) break;
                            return false;
                        }
                        LOG.warn("CSSValue '" + property.getValue().getCssText() + "' not supported for feature 'orientation'.");
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static float pixelValue(CSSValueImpl cssValue, SimpleScriptable scriptable) {
        switch (cssValue.getPrimitiveType()) {
            case 5: {
                return cssValue.getFloatValue((short)5);
            }
            case 3: {
                return 16.0f * cssValue.getFloatValue((short)3);
            }
            case 2: {
                return 0.16f * cssValue.getFloatValue((short)2);
            }
            case 4: {
                return 0.16f * cssValue.getFloatValue((short)4);
            }
            case 7: {
                int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                return (float)dpi / 25.4f * cssValue.getFloatValue((short)7);
            }
            case 6: {
                int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                return (float)dpi / 254.0f * cssValue.getFloatValue((short)6);
            }
            case 9: {
                int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                return (float)dpi / 72.0f * cssValue.getFloatValue((short)9);
            }
        }
        LOG.warn("CSSValue '" + cssValue.getCssText() + "' has to be a 'px', 'em', '%', 'mm', 'ex', or 'pt' value.");
        return -1.0f;
    }

    private static float resolutionValue(CSSValueImpl cssValue) {
        if (cssValue.getPrimitiveType() == 18) {
            String text = cssValue.getCssText();
            if (text.endsWith("dpi")) {
                return cssValue.getFloatValue((short)18);
            }
            if (text.endsWith("dpcm")) {
                return 2.54f * cssValue.getFloatValue((short)18);
            }
            if (text.endsWith("dppx")) {
                return 96.0f * cssValue.getFloatValue((short)18);
            }
        }
        LOG.warn("CSSValue '" + cssValue.getCssText() + "' has to be a 'dpi', 'dpcm', or 'dppx' value.");
        return -1.0f;
    }

    public static void validateSelectors(SelectorList selectorList, int documentMode, DomNode domNode) throws CSSException {
        for (Selector selector : selectorList) {
            if (CSSStyleSheet.isValidSelector(selector, documentMode, domNode)) continue;
            throw new CSSException("Invalid selector: " + selector);
        }
    }

    private static boolean isValidSelector(Selector selector, int documentMode, DomNode domNode) {
        switch (selector.getSelectorType()) {
            case ELEMENT_NODE_SELECTOR: {
                List<Condition> conditions = ((ElementSelector)selector).getConditions();
                if (conditions != null) {
                    for (Condition condition : conditions) {
                        if (CSSStyleSheet.isValidCondition(condition, documentMode, domNode)) continue;
                        return false;
                    }
                }
                return true;
            }
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                return CSSStyleSheet.isValidSelector(ds.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(ds.getSimpleSelector(), documentMode, domNode);
            }
            case CHILD_SELECTOR: {
                ChildSelector cs = (ChildSelector)selector;
                return CSSStyleSheet.isValidSelector(cs.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(cs.getSimpleSelector(), documentMode, domNode);
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                return CSSStyleSheet.isValidSelector(das.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(das.getSimpleSelector(), documentMode, domNode);
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                return CSSStyleSheet.isValidSelector(gas.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(gas.getSimpleSelector(), documentMode, domNode);
            }
        }
        LOG.warn("Unhandled CSS selector type '" + (Object)((Object)selector.getSelectorType()) + "'. Accepting it silently.");
        return true;
    }

    private static boolean isValidCondition(Condition condition, int documentMode, DomNode domNode) {
        switch (condition.getConditionType()) {
            case ID_CONDITION: 
            case CLASS_CONDITION: 
            case ATTRIBUTE_CONDITION: 
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: 
            case ONE_OF_ATTRIBUTE_CONDITION: 
            case LANG_CONDITION: {
                return true;
            }
            case PSEUDO_CLASS_CONDITION: {
                PseudoClassCondition pcc = (PseudoClassCondition)condition;
                String value = pcc.getValue();
                if (value.endsWith(")")) {
                    if (value.endsWith("()")) {
                        return false;
                    }
                    value = value.substring(0, value.indexOf(40) + 1) + ')';
                }
                if (documentMode < 9) {
                    return CSS2_PSEUDO_CLASSES.contains(value);
                }
                if (!CSS2_PSEUDO_CLASSES.contains(value) && domNode.hasFeature(BrowserVersionFeatures.QUERYSELECTOR_CSS3_PSEUDO_REQUIRE_ATTACHED_NODE) && !domNode.isAttachedToPage() && !domNode.hasChildNodes()) {
                    throw new CSSException("Syntax Error");
                }
                if ("nth-child()".equals(value)) {
                    String arg = StringUtils.substringBetween(pcc.getValue(), "(", ")").trim();
                    return "even".equalsIgnoreCase(arg) || "odd".equalsIgnoreCase(arg) || NTH_NUMERIC.matcher(arg).matches() || NTH_COMPLEX.matcher(arg).matches();
                }
                return CSS3_PSEUDO_CLASSES.contains(value);
            }
        }
        LOG.warn("Unhandled CSS condition type '" + (Object)((Object)condition.getConditionType()) + "'. Accepting it silently.");
        return true;
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }

    private CSSStyleSheetImpl.CSSStyleSheetRuleIndex getRuleIndex() {
        CSSStyleSheetImpl styleSheet = (CSSStyleSheetImpl)this.getWrappedSheet();
        CSSStyleSheetImpl.CSSStyleSheetRuleIndex index = styleSheet.getRuleIndex();
        if (index == null) {
            index = new CSSStyleSheetImpl.CSSStyleSheetRuleIndex();
            CSSRuleListImpl ruleList = (CSSRuleListImpl)styleSheet.getCssRules();
            this.index(index, ruleList, new HashSet<String>());
            styleSheet.setRuleIndex(index);
        }
        return index;
    }

    private void index(CSSStyleSheetImpl.CSSStyleSheetRuleIndex index, CSSRuleListImpl ruleList, Set<String> alreadyProcessing) {
        for (org.w3c.dom.css.CSSRule rule : ruleList.getRules()) {
            MediaList mediaList;
            short ruleType = rule.getType();
            if (1 == ruleType) {
                CSSStyleRuleImpl styleRule = (CSSStyleRuleImpl)rule;
                SelectorList selectors = styleRule.getSelectors();
                for (Selector selector : selectors) {
                    SimpleSelector simpleSel = selector.getSimpleSelector();
                    if (Selector.SelectorType.ELEMENT_NODE_SELECTOR == simpleSel.getSelectorType()) {
                        Condition c;
                        ElementSelector es = (ElementSelector)simpleSel;
                        boolean wasClass = false;
                        List<Condition> conds = es.getConditions();
                        if (conds != null && conds.size() == 1 && Condition.ConditionType.CLASS_CONDITION == (c = conds.get(0)).getConditionType()) {
                            index.addClassSelector(es, ((ClassCondition)c).getValue(), selector, styleRule);
                            wasClass = true;
                        }
                        if (wasClass) continue;
                        index.addElementSelector(es, selector, styleRule);
                        continue;
                    }
                    index.addOtherSelector(selector, styleRule);
                }
                continue;
            }
            if (3 == ruleType) {
                CSSImportRuleImpl importRule = (CSSImportRuleImpl)rule;
                mediaList = importRule.getMedia();
                CSSStyleSheet sheet = this.imports_.get(importRule);
                if (sheet == null) {
                    String href = importRule.getHref();
                    String url = UrlUtils.resolveUrl(this.getUri(), href);
                    sheet = CSSStyleSheet.loadStylesheet(this.ownerNode_, null, url);
                    this.imports_.put(importRule, sheet);
                }
                if (alreadyProcessing.contains(sheet.getUri())) continue;
                org.w3c.dom.css.CSSRuleList sheetRuleList = sheet.getWrappedSheet().getCssRules();
                alreadyProcessing.add(sheet.getUri());
                if (mediaList.getLength() == 0 && index.getMediaList().getLength() == 0) {
                    this.index(index, (CSSRuleListImpl)sheetRuleList, alreadyProcessing);
                    continue;
                }
                this.index(index.addMedia(mediaList), (CSSRuleListImpl)sheetRuleList, alreadyProcessing);
                continue;
            }
            if (4 != ruleType) continue;
            CSSMediaRuleImpl mediaRule = (CSSMediaRuleImpl)rule;
            mediaList = mediaRule.getMedia();
            if (mediaList.getLength() == 0 && index.getMediaList().getLength() == 0) {
                this.index(index, (CSSRuleListImpl)mediaRule.getCssRules(), alreadyProcessing);
                continue;
            }
            this.index(index.addMedia(mediaList), (CSSRuleListImpl)mediaRule.getCssRules(), alreadyProcessing);
        }
    }

    private List<CSSStyleSheetImpl.SelectorEntry> selects(CSSStyleSheetImpl.CSSStyleSheetRuleIndex index, SimpleScriptable scriptable, BrowserVersion browserVersion, DomElement element, String pseudoElement, boolean fromQuerySelectorAll) {
        ArrayList<CSSStyleSheetImpl.SelectorEntry> matchingRules = new ArrayList<CSSStyleSheetImpl.SelectorEntry>();
        if (CSSStyleSheet.isActive(scriptable, index.getMediaList())) {
            String elementName = element.getLowercaseName();
            String[] classes = StringUtils.split(element.getAttributeDirect("class"), null, -1);
            Iterator<CSSStyleSheetImpl.SelectorEntry> iter = index.getSelectorEntriesIteratorFor(elementName, classes);
            CSSStyleSheetImpl.SelectorEntry entry = iter.next();
            while (null != entry) {
                if (CSSStyleSheet.selects(browserVersion, entry.getSelector(), element, pseudoElement, fromQuerySelectorAll)) {
                    matchingRules.add(entry);
                }
                entry = iter.next();
            }
            for (CSSStyleSheetImpl.CSSStyleSheetRuleIndex child : index.getChildren()) {
                matchingRules.addAll(this.selects(child, scriptable, browserVersion, element, pseudoElement, fromQuerySelectorAll));
            }
        }
        return matchingRules;
    }

    static {
        CSS3_PSEUDO_CLASSES.addAll(CSS2_PSEUDO_CLASSES);
    }
}

